/**
 * Copyright 2007 Kristian Borum
 */

/**********************************************************************
 * Globals
 **********************************************************************/

var xml_request   = null;
var authtoken     = null;
var db            = new Array(); // A list of tuples (title,updated,type,icon).
var timer         = null; // Used for periodic refresh of the document list.
var max_rows      = 20;   // Maximum allowed number of rows.
var front_rows    = 4;    // Max number of rows shown.
var wide_mode     = 0;    // Make front side extra wide.
var front_height  = 142; 
var front_width   = 240;
var back_height   = 160;
var back_width    = 320;
var email         = null;
var password      = null;
var folder        = "";
var folders       = new Array();
var last_update   = null; // atom:updated value used for polling
var update_freq   = 600;   // Seconds between updates
var status_value  = 0;
var status_tvalue = -1;
var status_timer  = null;
var ul_queue      = new Array();
var populate_folders = true; // Fetch all documents to get the folder names.

var version       = "1.12";
var last_check    = 0;
var xml_checkrequest = null;
var updateURL     = "";

// Fetch state for the widget.
// 0: initial state (off)
// 1: authenticating (yellow)
// 2: authentication error occurred (red)
// 3: fetching
// 4: polling
// 5: waiting (green)
// 6: waiting, last poll failed (???)
// 7: posting data
// 8: check for widget update
var fetchState  = 0;


/**********************************************************************
 * UI
 **********************************************************************/

function loadPrefs() 
{
  if( window.widget )
  {
  
    front_rows = parseInt( widget.preferenceForKey( "RowCount" ) );
    if( isNaN( front_rows ) ) front_rows = 4;
  
    var wide   = widget.preferenceForKey( "Wide" );
    email      = widget.preferenceForKey( "Email" );
    last_check = parseInt( widget.preferenceForKey( "UpdateCheck" ) );
    password   = KrisbGdocsPlugin.getPassword();
    folder     = widget.preferenceForKey( "Folder" );
    if ( front_rows == undefined )
      front_rows = 4;
    if ( wide == undefined )
      wide = false;
    if ( email == undefined )
      email = "";
    if ( folder == undefined )
      folder = "";
    if ( isNaN( last_check ) )
      last_check = 0;
    setItemCount( front_rows );
    front_rows = parseInt( document.getElementById( 'sliderItemCount' ).value );
    wide_mode = ( wide == 'true' ? 1 : 0 );
    document.getElementById( "textfieldEmail" ).value = email;
    document.getElementById( "textfieldPassword" ).value = password;
    document.getElementById( "cbWide" ).checked = wide_mode;
    setFolder( folder );
    document.getElementById( "textLastUpdate" ).innerHTML = email;
  }
}

function savePrefs() 
{
  if( window.widget )
  {
    var wide = wide_mode == 1 ? 'true' : 'false';
    widget.setPreferenceForKey( front_rows, "RowCount" );        
    widget.setPreferenceForKey( wide, "Wide" );
    widget.setPreferenceForKey( email, "Email" );
    widget.setPreferenceForKey( folder, "Folder" );
    KrisbGdocsPlugin.setPassword( password );    
  }
}

function setNotice( text ) {
  if ( text == null )
    text = 'Krisb Gdocs Widget (v'+ version +')';
  document.getElementById( "textStatus" ).innerHTML = text;
}

function setFolder( name ) {
  folder = name;
  if ( name == "" )
    name = "All documents";
  document.getElementById( "textHeaderName" ).innerHTML = name;
}

function setItemCount( count )
{
  if ( !count || count.length == 0 ) count = front_rows;
  if ( count < 1 ) count = 1;
  if ( count > max_rows ) count = max_rows;
  sliderItemCount.value = count;
  textItemCount.innerText = count;
}


function checkUpdate() {
  var now = new Date().getTime();
  if ( last_check + ( 1000 * 3600 * 24 ) < now )
    requestCheckUpdate();
}

function showBack( event )
{
    var front = document.getElementById( "front" );
    var back = document.getElementById( "back" );
    var cur_w = front_width;
    var cur_h = front_height;
    if ( window.widget ) {
      if ( cur_h <= back_height ) {
        window.resizeTo( cur_w, back_height );
        cur_h = back_height;
      }
      if ( cur_w <= back_width ) {
        window.resizeTo( back_width, cur_h );
        cur_w = back_width;
      }
      widget.prepareForTransition( "ToBack" );
      window.resizeTo( back_width, back_height );
    }
    front.style.display = "none";
    back.style.display  = "block";
    if ( window.widget ) {
      setTimeout( 'widget.performTransition();', 0 );
    }
}

function showFront( event )
{
  // Apply changes.
  front_rows = parseInt( document.getElementById( 'sliderItemCount' ).value );
  wide_mode  = document.getElementById( 'cbWide' ).checked ? 1 : 0;
  setFolder( folder );
  document.getElementById( "textLastUpdate" ).innerHTML = email;
  savePrefs();
  updateList();

  var front = document.getElementById( "front" );
  var back = document.getElementById( "back" );
  if ( window.widget ) {
    var cur_w = back_width;
    var cur_h = back_height;
    if ( cur_h <= front_height ) {
      window.resizeTo( cur_w, front_height );
      cur_h = front_height;
    }
    if ( cur_w <= front_width ) {
      window.resizeTo( front_width, cur_h );
      cur_w = front_width;
    }
    widget.prepareForTransition( "ToFront" );
    window.resizeTo( front_width, front_height );
  }
  front.style.display = "block";
  back.style.display = "none";
  if ( window.widget ) {
    setTimeout( 'widget.performTransition();', 0 );
  }
}

/**********************************************************************
 * List
 **********************************************************************/
var eleTitle = new Array();
var eleDate  = new Array();
var eleIcon  = new Array();
var eleRow   = new Array();
var old_wide = 2;
var old_rows = 0;

function updateList() {
  // Create rows
  if ( old_rows < front_rows ) {
    for( i=0; i<front_rows; i++ ) {
      if ( i >= eleTitle.length ) {
        var title;
        title = document.createElement ('div');
        title.setAttribute ( 'id', 'textDocTitle' + i );
        title.setAttribute ( 'class', 'documentTitle' );
        title.onclick = openDoc;
        title.itemIndex = i;
        title.style.setProperty( 'top', ( 34 + i * 18 ) + 'px' );
        document.getElementById('tbody').appendChild( title );
      eleTitle[ i ] = title;
      }
      if ( i >= eleDate.length ) {
        var date;
        date = document.createElement ('div');
        date.setAttribute ( 'id', 'textDocDate' + i );
        date.setAttribute ( 'class', 'documentDate' );
        date.onclick = openDoc;
        date.itemIndex = i;
        date.style.setProperty( 'top', ( 34 + i * 18 ) + 'px' );
        document.getElementById('tbody').appendChild( date );    
        eleDate[ i ] = date;
      }
      if ( i >= eleIcon.length ) {
        var icon;
        icon = document.createElement ('div');
        icon.setAttribute ( 'id', 'iconDocIcon' + i );
        icon.onclick = openDoc;
        icon.itemIndex = i;
        icon.style.setProperty( 'top', ( 35 + i * 18 ) + 'px' );
        document.getElementById('tbody').appendChild( icon );    
        eleIcon[ i ] = icon;
      }
      if ( i >= eleRow.length ) {
        var row;
        row = document.createElement ('div');
        row.setAttribute ( 'id', 'rectDocRow' + i );
        row.setAttribute ( 'class', 'documentRow' );
        if ( i & 1 ) row.style.setProperty( 'background-color', '#e5e5e5' );
        row.onclick = openDoc;
        row.itemIndex = i;
        row.style.setProperty( 'top', ( 34 + i * 18 ) + 'px' );
        document.getElementById('tbody').appendChild( row );    
        eleRow[ i ] = row;
      }
    }
  }
  // Position decorations
  front_width  = wide_mode == 1 ? 320 : 240;
  front_height = ( 80 + 18 * front_rows );
  if ( old_wide != wide_mode ) {
    document.getElementById( 'frameTopMiddle' ).style.setProperty( 'width', ( front_width - 48 ) + 'px' );
    document.getElementById( 'frameTopRight' ).style.setProperty( 'left', ( front_width - 24 ) + 'px' );
    document.getElementById( 'frameMiddleMiddle' ).style.setProperty( 'width', ( front_width - 48 ) + 'px' );
    document.getElementById( 'frameMiddleRight' ).style.setProperty( 'left', ( front_width - 24 ) + 'px' );
    document.getElementById( 'frameBottomMiddle' ).style.setProperty( 'width', ( front_width - 48 ) + 'px' );
    document.getElementById( 'frameBottomRight' ).style.setProperty( 'left', ( front_width - 24 ) + 'px' );
    document.getElementById( 'info' ).style.setProperty( 'left', ( front_width - 31 ) + 'px' );
    document.getElementById( 'textHeaderName' ).style.setProperty( 'width', ( front_width - 40 ) + 'px' );
    document.getElementById( 'textLastUpdate' ).style.setProperty( 'width', ( front_width - 40 ) + 'px' );
  }
  if ( old_rows != front_rows ) {
    document.getElementById( 'frameBottomLeft' ).style.setProperty( 'top', ( 34 + front_rows * 18 ) + 'px' );
    document.getElementById( 'frameBottomMiddle' ).style.setProperty( 'top', ( 34 + front_rows * 18 ) + 'px' );
    document.getElementById( 'frameBottomRight' ).style.setProperty( 'top', ( 34 + front_rows * 18 ) + 'px' );
    document.getElementById( 'frameMiddleLeft' ).style.setProperty( 'height', ( front_rows * 18 ) + 'px' );
    document.getElementById( 'frameMiddleMiddle' ).style.setProperty( 'height', ( front_rows * 18 ) + 'px' );
    document.getElementById( 'frameMiddleRight' ).style.setProperty( 'height', ( front_rows * 18 ) + 'px' );
    document.getElementById( 'info' ).style.setProperty( 'top', ( 39 + front_rows * 18 ) + 'px' );
    document.getElementById( 'indicator' ).style.setProperty( 'top', ( 36 + front_rows * 18 ) + 'px' );
  }
  // Content
  var shown = 0;
  for ( i=0; shown<front_rows && i<db.length; i++ ) {
    if ( folder == "" || folder == db[ i ].folder ) {
      eleTitle[ shown ].innerText = db[i].title;
      eleDate[ shown ].innerText  = db[i].date;
      eleIcon[ shown ].setAttribute( 'class', db[i].icon );
      shown++;
    }
  }
  for ( i=shown; i<front_rows; i++ ) {
    eleTitle[ i ].innerText = '';
    eleDate[ i ].innerText  = '';
    eleIcon[ i ].setAttribute( 'class', 'imageIconNone' );  
  }
  
  // Show and position used rows
  if ( old_rows != front_rows || old_wide != wide_mode ) {
    for ( i=0; i<max_rows; i++ ) {
      if ( i < eleTitle.length ) {
        eleTitle[ i ].style.setProperty( 'visibility', i < front_rows ? 'visible' : 'hidden' ); 
        eleTitle[ i ].style.setProperty( 'width', ( front_width - 117 ) + 'px' ); 
      }
      if ( i < eleDate.length ) {
        eleDate[ i ].style.setProperty( 'visibility', i < front_rows ? 'visible' : 'hidden' ); 
        eleDate[ i ].style.setProperty( 'left', ( front_width - 81 ) + 'px' ); 
      }
      if ( i < eleIcon.length ) {
        eleIcon[ i ].style.setProperty( 'visibility', i < front_rows ? 'visible' : 'hidden' ); 
        eleIcon[ i ].style.setProperty( 'width', ( front_width - 34 ) + 'px' ); 
      }
      if ( i < eleRow.length ) {
        eleRow[ i ].style.setProperty( 'visibility', i < front_rows ? 'visible' : 'hidden' ); 
        eleRow[ i ].style.setProperty( 'width', ( front_width - 34 ) + 'px' ); 
      }
    }
  }
  old_wide = wide_mode;
  old_rows = front_rows;
}

function updateFolderList() {
  folders.sort();
  var new_folders = new Array();
  var cur = null;
  for ( i=0; i<folders.length; i++ ) {
    if ( cur != folders[ i ] ) {
      cur = folders[ i ];
      new_folders.push( cur );
    }
  }
  folders = new_folders;
  for ( i=0; i<folders.length; i++ )
  {
    var ele = document.getElementById( 'folderName' + ( i + 1 ) );
    if ( ele == null ) {
      ele = document.createElement ('option');
      ele.setAttribute ( 'id', 'folderName' + ( i + 1 ) );
      document.getElementById('popupFolder').appendChild( ele ); 
    }
    ele.innerText = folders[ i ];
  }
  document.getElementById("popupFolder").value = folder;
  document.getElementById("popupFolder").removeAttribute( "disabled" );
}


/**********************************************************************
 * Content
 **********************************************************************/
 
function findChild( element, nodeName )
{
	var child;
	for ( child = element.firstChild; child != null; child = child.nextSibling )
	{
		if (child.nodeName == nodeName)
			return child;
	}
	return null;
}

function googTimetoJSDate( gt )
{
  var d = new Date();
  d.setUTCFullYear( gt.substring( 0, 4 ),
                    gt.substring( 5, 7 )-1,
                    gt.substring( 8, 10 ) );
  d.setUTCHours( gt.substring( 11, 13 ),
                 gt.substring( 14, 16 ),
                 gt.substring( 17, 19 ),
                 gt.substring( 20, 23 ) );
  return d;
}

function googTimeToDate( gt ) 
{
  var std_date_str = gt.substring( 0, 10 ) + " " + gt.substring( 11, 19 ) + " +0000";
  var d = googTimetoJSDate( gt );
  //if ( d > new Date() ) return "future";
  if ( new Date( d.getTime() + 86400000 ) > ( new Date() ) )
    return KrisbGdocsPlugin.formatTime( std_date_str );
  return KrisbGdocsPlugin.formatDate( std_date_str );
}

function xml_checkloaded ( type, request ) {
  if ( request.status == 200 ) {
    last_check = new Date().getTime();
    widget.setPreferenceForKey( ""+last_check, "UpdateCheck" );
    var action  = request.responseXML.getElementsByTagName( 'action' ).item(0).firstChild.nodeValue;
    var message = request.responseXML.getElementsByTagName( 'message' ).item(0).firstChild.nodeValue;
    if ( action == "update" ) {
      updateURL = request.responseXML.getElementsByTagName( 'url' ).item(0).firstChild.nodeValue;
      document.getElementById( 'update' ).style.setProperty( 'visibility', 'visible' );
      setNotice( message );
      showBack();
    }
  }
}

function xml_loaded ( type, request ) 
{

// TODO handle these:
// http://code.google.com/apis/gdata/auth.html

  if ( request.status == 200 ) {
    if ( type == 1 ) // Handle authentication responses
    {
      authtoken = "";
      var sa = request.responseText.split( "\n" );
      for( i=0; i<sa.length; i++ )
        if ( sa[i].indexOf( "Auth=" ) == 0 )
          authtoken = sa[i].substring( 5 );
      if ( authtoken != "" )
        getList();
    }   
    if ( type == 2 ) // Handle getList responses
    {
    	if ( request.responseXML )
      {		
        db = new Array();
        var upd = request.responseXML.getElementsByTagName( 'updated' ).item(0).firstChild.nodeValue;
        last_update = new Date();
        last_update.setTime( googTimetoJSDate( upd ).getTime() + 0 );

        var entries = request.responseXML.getElementsByTagName( 'entry' );
        for ( i=0; i <entries.length; ++i) {
          var xmlItem = entries.item(i);
          var child;
          var title = null;
          var updated;
          var date;
          var icon;
          var content;
          var type;
          var folder = null;

        	for ( child = xmlItem.firstChild; child != null; child = child.nextSibling )
          {
            if ( child.nodeName == 'title' )
              title = child.childNodes[0].nodeValue;
            if ( child.nodeName == 'updated' )
              updated = child.childNodes[0].nodeValue;
            if ( child.nodeName == 'link' && child.getAttribute( 'rel' ) == 'alternate' )
              content = child.getAttribute( 'href' );
            if ( child.nodeName == 'category' && child.getAttribute( 'scheme' ) == 'http://schemas.google.com/g/2005#kind' )
              type = child.getAttribute( 'label' );
            if ( child.nodeName == 'category' && child.getAttribute( 'scheme' ) == 'http://schemas.google.com/docs/2007/folders/' + email )
              folder = child.getAttribute( 'label' );
          }
          if ( folder != null )
            folders.push( folder );
          else
            folder = "";
          date = googTimeToDate( updated );
          icon =  'imageIconNone';
          if ( type == 'document' )
            icon = 'imageIconDocument';
          if ( type == 'presentation' )
            icon = 'imageIconPresentation';
          if ( type == 'spreadsheet' )
            icon = 'imageIconSpreadsheet';
          
          if ( title != null ) {
            //alert ( "*** " + content);
            db[ db.length ] = { title:title, updated:updated, link:content, type:type, date:date, icon:icon, folder:folder };
           // alert( title + " " + updated + " " + content + " " + type );
          }
        }
      } 
      setStatus( 1 );
      fetchState = 5;
      if ( timer != null )
        clearTimeout( timer );
      timer = null;
      timer = setTimeout( "pollList()", update_freq * 1000 );
      updateList();
      updateFolderList();
    }
	}
/*
  else if ( request.status == 201 )
  {
    setStatus( 1 );
    fetchState = 5;
    if ( timer != null )
      clearTimeout( timer );
    timer = null;
    getList();
  }
  */
  else if ( request.status == 403 || request.status == 401 )
  {
    setStatus( 3 );
    fetchState = 0;
    alert("Error fetching type " + type + " data: HTTP status " + request.status + " " + request.statusText );
  }
  else
  {
    // Error types:
    //   500 Unknown error 
    //   400 Could not convert.
    //   304 No changes
    alert( "Warning: [" + request.status + " " + request.statusText + "] " + request.responseText );

    setStatus( 1 );
    setTempStatus( 3 );
    
    fetchState = 5;
    if ( timer != null )
      clearTimeout( timer );
    timer = null;
    timer = setTimeout( "pollList()", update_freq * 1000 );
  }    
  postFile(); // Upload pending file.
}

function setStatus( v )
{
   status_value = v;
   var s = v;
   if ( status_tvalue != -1 )
     s = status_tvalue; 
   document.getElementById( "indicator" ).object.setValue( s );
   document.getElementById( "indicatorBack" ).object.setValue( s );
}

function setTempStatus( v )
{
  status_tvalue = v;
  setStatus( status_value );  
  status_timer = setTimeout( "clearTempStatus()", 1000 );
}

function clearTempStatus() {
  status_tvalue = -1;
  setStatus( status_value );
  status_timer = null
}

function getList()
{
  setStatus( 2 );
  fetchState = 3;
  if ( xml_request.readyState > 0 && xml_request.readyState < 4 )
    xml_request.abort();
  xml_request.onload = function() { xml_loaded( 2, xml_request ); };
  var url = "https://docs.google.com/feeds/documents/private/full/-/{http:%2F%2Fschemas.google.com%2Fdocs%2F2007%2Ffolders%2F" + email + "}" + folder + "?max-results=" + max_rows;
  
  if ( folder == "" )
    url = "https://docs.google.com/feeds/documents/private/full?max-results=" + max_rows;
  if ( populate_folders ) 
    url = "https://docs.google.com/feeds/documents/private/full";
 
  xml_request.open( "GET", url, true );
  xml_request.overrideMimeType( "text/xml" );
  xml_request.setRequestHeader( "Cache-Control", "no-cache" );
  xml_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
  xml_request.setRequestHeader( "Authorization", "GoogleLogin auth=\"" + authtoken + "\"" );
  xml_request.send( null );  
  populate_folders = false;
}

function pollList() {
  getList();
/*
  setStatus( 2 );
  fetchState = 4;
  if ( xml_request.readyState > 0 && xml_request.readyState < 4 )
    xml_request.abort();
  xml_request.onload = function() { xml_loaded( 2, xml_request ); };
  xml_request.open( "GET", "https://docs.google.com/feeds/documents/private/full?max-results=" + max_rows, true );
  xml_request.overrideMimeType( "text/xml" );
  xml_request.setRequestHeader( "Cache-Control", "no-cache" );
  xml_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
  xml_request.setRequestHeader( "Authorization", "GoogleLogin auth=\"" + authtoken + "\"" );
  //xml_request.setRequestHeader( "If-Modified-Since", "" + last_update.toUTCString() );
  
 
  //alert( "PL: *" + last_update.toUTCString() +"*" );
  //http://www.example.com/feeds/jo?q=Darcy&updated-min=2005-04-19T15:30:00 
  xml_request.send( null );  
  
  */
}

function requestCheckUpdate() {
  if ( !xml_checkrequest )
    xml_checkrequest = new XMLHttpRequest();
  if ( xml_checkrequest.readyState > 0 && xml_checkrequest.readyState < 4 )
    xml_checkrequest.abort();
  xml_checkrequest.onload = function() { xml_checkloaded( 3, xml_checkrequest ); };
  xml_checkrequest.open( "GET", "http://algoritmer.dk/krisb/check.php?version=" + version, true );
  xml_checkrequest.overrideMimeType( "text/xml" );
  xml_checkrequest.setRequestHeader( "Cache-Control", "no-cache" );
  xml_checkrequest.send( null );  
}

function mimeTypeFromSuffix( suffix ) {
  if ( suffix == 'csv' )  return 'text/csv';
  if ( suffix == 'tsv' )  return 'text/tab-separated-values';
  if ( suffix == 'tab' )  return 'text/tab-separated-values';
  if ( suffix == 'html' ) return 'text/html';
  if ( suffix == 'htm' )  return 'text/html';
  if ( suffix == 'doc' )  return 'application/msword';
  if ( suffix == 'ods' )  return 'application/x-vnd.oasis.opendocument.spreadsheet';
  if ( suffix == 'odt' )  return 'application/vnd.oasis.opendocument.text';
  if ( suffix == 'rtf' )  return 'application/rtf';
  if ( suffix == 'sxw' )  return 'application/vnd.sun.xml.writer';
  if ( suffix == 'txt' )  return 'text/plain';
  if ( suffix == 'xls' )  return 'application/vnd.ms-excel';
  if ( suffix == 'ppt' )  return 'application/vnd.ms-powerpoint';
  if ( suffix == 'pps' )  return 'application/vnd.ms-powerpoint';
  return "";
}

function queueFile( file ) {
  ul_queue.push( file );  
}

function postFile() {
  if ( fetchState != 5 )
    return;
  var file = ul_queue.shift();
  if ( file == undefined || file == null )
    return;  
  var parts   = file.split( "/" );	
  var docFile = "";
  if ( parts.length < 4 || parts[0] != 'file:' )
    return; // Dont do anything unless the URI look right
  for ( i=3; i<parts.length; i++ )
    docFile = docFile + '/' + parts[ i ];
  var filename = unescape( parts.pop() );
  var docName = filename.substr( 0, filename.lastIndexOf( "." ) );
  var docType = filename.substr( filename.lastIndexOf( "." ) + 1 );
  var docMime = mimeTypeFromSuffix( docType.toLowerCase() );
  if ( docMime == "" )
    return setTempStatus( 3 ); // Undefined mimetype  
  setStatus( 2 );
 // alert( "Posting doc " + docName + " from path " + docFile + " " + docName+ " " + docType + " (" + file + ")" );
  var data = KrisbGdocsPlugin.readFile( unescape( docFile ) );
  if ( data == null || data.length == 0 )
    return setTempStatus( 3 ); // Got zero bytes, something went wrong.
    
  var preheader = "Media multipart posting\r\n--END_OF_PART\r\n";
  preheader += "Content-Type: application/atom+xml\r\n\r\n";
  preheader += '<?xml version="1.0" encoding="UTF-8"?>\r\n';
  //preheader += '<!-- 12345678901234567890123456789012345678901234567890123456789012345678901234567890 -->\r\n';
  preheader += '<atom:entry xmlns:atom="http://www.w3.org/2005/Atom">\r\n';
  preheader += '<atom:category scheme="http://schemas.google.com/g/2005#kind" term="http://schemas.google.com/docs/2007#document"/>\r\n';
  preheader += '<atom:title>' + docName+ '</atom:title>\r\n';
  preheader += '</atom:entry>\r\n';
  preheader += '--END_OF_PART\r\n';
  preheader += 'Content-Type: ' + docMime + '\r\n';
  preheader += 'Content-Transfer-Encoding: binary\r\n';
  preheader += 'Slug: ' + docName + '.' + docType + '\r\n\r\n';
  var postheader = "\r\n--END_OF_PART--\r\n";

  var url = "http://docs.google.com/feeds/documents/private/full";
  var body = preheader + data + postheader;
  var ret = KrisbGdocsPlugin.requestPost( url, docMime, docName, filename, "GoogleLogin auth=\"" + authtoken + "\"", body );
  if ( ret == 201 )
    refreshList(); 
  else
    return setTempStatus( 3 );
}

function refreshList() {
  if ( fetchState == 0 )
    authenticate();
  if ( fetchState == 5 || fetchState == 6 )
    pollList();
}

// Called when the user changes either email or password.
function authenticate()
{
  var email      = document.getElementById( "textfieldEmail" ).value;
  var password   = document.getElementById( "textfieldPassword" ).value;
  if ( email == "" || password == "" ) return;
  var parameters = "accountType=GOOGLE" +
    "&Email=" + email +
    "&Passwd=" + password +
    "&service=writely" +
    "&source=KrisbGdocsWidget-1.01";
  fetchState = 1; 
  if ( !xml_request )
    xml_request = new XMLHttpRequest();
  if ( xml_request.readyState > 0 && xml_request.readyState < 4 )
    xml_request.abort();
  setStatus( 2 );
  xml_request.onload = function() { xml_loaded( 1, xml_request ); };
  xml_request.open( "POST", "https://www.google.com/accounts/ClientLogin", true );
  xml_request.overrideMimeType( "text/html" );
  xml_request.setRequestHeader( "Cache-Control", "no-cache" );
  xml_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
  xml_request.send( parameters );  
}

/**********************************************************************
 * Event handlers
 **********************************************************************/

function load()
{ 
  loadPrefs();
  updateList();
  window.resizeTo( front_width, front_height );
  setupParts();
  setNotice( null );
}

function remove()
{
  if ( timer != null )
    clearTimeout( timer );
  timer = null; 
}

function hide()
{
  if ( timer != null )
    clearTimeout( timer );
  timer = null;
}

function show()
{
  refreshList();
  checkUpdate();
}

function sync()
{
}

function sliderItemCountEvent( event )
{
  setItemCount( sliderItemCount.value );
}

function openDoc( event )
{
  var idx = event.srcElement.itemIndex;
  if ( idx < db.length )
    widget.openURL( db[ idx ].link+"&auth="+authtoken );
} 

function openHome( event )
{
  widget.openURL( 'http://www.algoritmer.dk/krisb/' );
}

function eventUpdate(event) {
  document.getElementById("update").style.setProperty( 'visibility', 'hidden' );
  setNotice( null );
  if(updateURL != "") widget.openURL( updateURL );
}

function emailChangeHandler( event )
{
  email = document.getElementById( "textfieldEmail" ).value;
  if ( email != "" && password != "" ) authenticate();
}

function passwordChangeHandler( event )
{
  password = document.getElementById( "textfieldPassword" ).value;
  if ( email != "" && password != "" ) authenticate();
}

function eventFolderChange(event)
{
  folder = document.getElementById( "popupFolder" ).value;
  getList();
}

function eventDrop(event)
{
	try {
		var uriString = event.dataTransfer.getData( "text/uri-list" );	
		var uriList   = uriString.split( "\n" );	
    for ( i=0; i<uriList.length; i++ )
      queueFile( uriList[ i ] );
	} catch ( ex ) {
		alert("Problem fetching URI: " + ex);
	}
	event.stopPropagation();
	event.preventDefault();
  postFile(); // Upload the files
}

function eventDragOver(event)
{
	event.stopPropagation();
	event.preventDefault();
}

function eventDragEnter(event)
{
	event.stopPropagation();
	event.preventDefault();
  event.dataTransfer.dropEffect = 'copy';
}

function eventDragStart(event)
{
  event.dataTransfer.effectAllowed = 'all';
  event.dataTransfer.setDragImage( event.srcElement, 8, 8 );
  event.dataTransfer.setData( "application/pdf", "http://developer.apple.com/images/developer_connection_title.pdf" );
  
}

function eventDragEnd(event) {
}

if ( window.widget ) {
  widget.onremove = remove;
  widget.onhide   = hide;
  widget.onshow   = show;
  widget.onsync   = sync;
}

  