/* 
 This file was generated by Dashcode and is covered by the 
 license.txt included in the project.  You may edit this file, 
 however it is recommended to first turn off the Dashcode 
 code generator otherwise the changes will be lost.
 */

// Note: Properties and methods beginning with underbar ("_") are considered private and subject to change in future Dashcode releases.

function CreateIndicator(elementOrID, spec)
{
    var indicatorElement = elementOrID;
    if (elementOrID.nodeType != Node.ELEMENT_NODE) {
        indicatorElement = document.getElementById(elementOrID);
    }	
    if (!indicatorElement.loaded) 
	{
		indicatorElement.loaded = true;
		indicatorElement.object = new Indicator(indicatorElement, spec.value || 0, spec.onValue || 0, spec.warningValue || 0, spec.criticalValue || 0, spec.imageOff || null, spec.imageOn || null, spec.imageWarning || null, spec.imageCritical || null);
		return indicatorElement.object;
	}
}

function Indicator(indicator, value, onValue, warningValue, criticalValue, imageOff, imageOn, imageWarning, imageCritical)
{
	/* Objects */
    this.element = indicator;
	this._indicator = indicator;
	
	/* public properties */
	// These are read-only. Use the setter functions to set them.
	this.value = value;
	
	/* Internal objects */
	this._image = null;
		
	this.imageOffPath = imageOff == null ? "Images/IndicatorOff.png" : imageOff;
	this.imageOnPath = imageOn == null ? "Images/IndicatorOn.png" : imageOn;
	this.imageWarningPath = imageWarning == null ? "Images/IndicatorWarning.png" : imageWarning;
	this.imageCriticalPath = imageCritical == null ? "Images/IndicatorCritical.png" : imageCritical;
		
	this._init(value, onValue, warningValue, criticalValue, imageOn, imageOff, imageWarning, imageCritical);
}

Indicator.prototype.remove = function()
{
	var parent = this._image.parentNode;
	parent.removeChild(this._image);
}

/*
 * refresh() member function
 * Refresh the current level indicator position.
 * Call this to make the level indicator appear after the widget has loaded and 
 * the Indicator object has been instantiated.
 */
Indicator.prototype.refresh = function()
{	
	this._computedIndicatorStyle = document.defaultView.getComputedStyle(this._indicator, '');
	this._setValueTo(this.value);
}

Indicator.prototype.setValue = function(newValue)
{
	this.value = newValue;
	this.refresh();
}

Indicator.prototype.setOnValue = function(newValue)
{
	this.onValue = newValue;
	this.refresh();
}

Indicator.prototype.setWarningValue = function(newValue)
{
	this.warningValue = newValue;
	this.refresh();
}

Indicator.prototype.setCriticalValue = function(newValue)
{
	this.criticalValue = newValue;
	this.refresh();
}

Indicator.prototype.setImageOff = function(newValue)
{
	this.imageOffPath = newValue;	
	this.refresh();
}

Indicator.prototype.setImageOn = function(newValue)
{
	this.imageOnPath = newValue;	
	this.refresh();
}

Indicator.prototype.setImageWarning = function(newValue)
{
	this.imageWarningPath = newValue;	
	this.refresh();
}

Indicator.prototype.setImageCritical = function(newValue)
{
	this.imageCriticalPath = newValue;	
	this.refresh();
}

Indicator.prototype._init = function(value, onValue, warningValue, criticalValue, imageOn, imageOff, imageWarning, imageCritical)
{
	// For JavaScript event handlers
	var _self = this;
	
	this.onValue = onValue;
	this.warningValue = warningValue;
	this.criticalValue = criticalValue;
	
	var style = null;
	var element = null;
    
    while (this._indicator.firstChild) {
        this._indicator.removeChild(this._indicator.firstChild);
    }
    
	// Level Indicator Track
	element = document.createElement("img");
	style = element.style;
	style.height = "100%";
	style.width = "100%";
	this._indicator.appendChild(element);
	this._image = element;
	
	this.refresh();
}


Indicator.prototype._setValueTo = function(newValue)
{	
	this.value = newValue;
    
	var imagePath = null;
    
	if (this.value >= this.criticalValue)
		imagePath = this.imageCriticalPath;
	else if (this.value >= this.warningValue)
		imagePath = this.imageWarningPath;
	else if (this.value >= this.onValue)
		imagePath = this.imageOnPath;
	else
		imagePath = this.imageOffPath;
    
	this._image.src = imagePath;
}

// Capture events that we don't handle but also don't want getting through
Indicator.prototype._captureEvent = function(event)
{
	event.stopPropagation();
	event.preventDefault();
}
